<?php
/**
 * Plugin Name: 不可投稿分类导航限显
 * Version: 1.0
 * Plugin URL: https://www.emlog.net
 * Description: 当文章分类设置为不可投稿时，该分类在导航栏中仅对登录用户 ID 为 1 的管理员显示，其他用户不显示。
 * Author: emlog
 * Author URL: https://www.emlog.net
 */
!defined('EMLOG_ROOT') && exit('access denied!');

const NO_SUBMIT_NAV_PLUGIN = 'no_submit_nav';

/**
 * 获取「不可投稿」分类 ID 列表（Storage 存储）
 */
function no_submit_nav_get_no_submit_sorts() {
    $storage = Storage::getInstance(NO_SUBMIT_NAV_PLUGIN);
    $raw = $storage->getValue('no_submit_sorts');
    if (empty($raw)) {
        return [];
    }
    $arr = is_array($raw) ? $raw : (array) json_decode($raw, true);
    return array_map('intval', array_filter($arr));
}

/**
 * 保存「不可投稿」分类 ID 列表
 */
function no_submit_nav_save_no_submit_sorts(array $sids) {
    $storage = Storage::getInstance(NO_SUBMIT_NAV_PLUGIN);
    $storage->setValue('no_submit_sorts', json_encode(array_values($sids)), 'string');
}

// ---------- 后台：分类编辑增加「不可投稿」选项 ----------
addAction('adm_sort_add', 'no_submit_nav_adm_sort_add');
function no_submit_nav_adm_sort_add() {
    $sid = Input::getIntVar('sid', 0);
    $no_submit_sorts = no_submit_nav_get_no_submit_sorts();
    $checked = ($sid > 0 && in_array($sid, $no_submit_sorts, true)) ? ' checked' : '';
    echo '<div class="form-group"><label class="col-form-label">不可投稿</label><div><label><input type="checkbox" name="no_submit_nav_sort" value="1"' . $checked . '> 勾选后该分类为不可投稿，导航栏中仅用户 ID 为 1 时显示</label></div></div>';
}

addAction('save_sort', 'no_submit_nav_save_sort');
function no_submit_nav_save_sort($sid, $sort_data) {
    $sid = (int) $sid;
    if ($sid <= 0) return;
    $no_submit_sorts = no_submit_nav_get_no_submit_sorts();
    $val = Input::postIntVar('no_submit_nav_sort', 0);
    if ($val) {
        if (!in_array($sid, $no_submit_sorts, true)) {
            $no_submit_sorts[] = $sid;
            no_submit_nav_save_no_submit_sorts($no_submit_sorts);
        }
    } else {
        $no_submit_sorts = array_values(array_diff($no_submit_sorts, [$sid]));
        no_submit_nav_save_no_submit_sorts($no_submit_sorts);
    }
}

// ---------- 前台：输出不可投稿分类 ID 与当前用户 ID（供导航隐藏逻辑使用） ----------
addAction('index_head', 'no_submit_nav_head_data');
function no_submit_nav_head_data() {
    $no_submit_sorts = no_submit_nav_get_no_submit_sorts();
    if (empty($no_submit_sorts)) {
        return;
    }
    $uid = defined('UID') ? (int) UID : 0;
    $sort_json = json_encode($no_submit_sorts);
    echo "<script>window._noSubmitNav={sortIds:$sort_json,uid:$uid};</script>\n";
}

// ---------- 前台：隐藏「不可投稿」分类的导航项（仅 UID=1 时显示） ----------
addAction('index_footer', 'no_submit_nav_footer_js');
function no_submit_nav_footer_js() {
    ?>
<script>
(function(){
    if (typeof window._noSubmitNav === 'undefined') return;
    var sortIds = window._noSubmitNav.sortIds || [];
    var uid = window._noSubmitNav.uid || 0;
    if (sortIds.length === 0) return;
    // 仅当用户 ID 不为 1 时，隐藏导航中指向「不可投稿」分类的链接
    if (uid === 1) return;

    var sortSet = {};
    for (var i = 0; i < sortIds.length; i++) sortSet[sortIds[i]] = 1;

    document.querySelectorAll('a[href*="sort"]').forEach(function(a){
        var href = a.href || '';
        var m = href.match(/[?&]sortid=(\d+)/) || href.match(/\/sort[\/\-]?(\d+)/);
        if (!m || !sortSet[parseInt(m[1], 10)]) return;
        var li = a.closest('li');
        var div = a.closest('div.joe_dropdown');
        if (li) li.style.display = 'none';
        else a.style.display = 'none';
        if (div && div.querySelectorAll('a[href*="sort"]').length === 1) div.style.display = 'none';
    });
})();
</script>
<?php
}
